/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include "alias.h"
#include "configuration.h"
#include "functionconstruction.h"
#include "ght_hash_table.h"
#include "configfile.h"

ght_hash_table_t	*alias_ht;

int UpdateAlias(char *name, char *command)
{
	if(RemoveAlias(name)) AddNewAlias(name, command);

	return TRUE;
}

int AddNewAlias(char *name, char *command)
{
	/*~~~~~~~~~~~~~~~*/
	ALIAS	*alias;
	/*~~~~~~~~~~~~~~~*/

	alias = (ALIAS *)malloc(sizeof(ALIAS));
	alias->name = malloc(strlen(name) + 1);
	strcpy(alias->name, name);
	alias->command = malloc(strlen(command) + 1);
	strcpy(alias->command, command);

	if(ght_insert(alias_ht, alias, sizeof(char) * strlen(name), name) == 0)
	{
		if(RegisterCommand(name, ProcessAlias)) return TRUE;	/* Success */
	}

	return FALSE;
}

int RemoveAlias(char *name)
{
	/*~~~~~~~~~~~~~~~*/
	ALIAS	*alias;
	/*~~~~~~~~~~~~~~~*/

	alias = ght_remove(alias_ht, strlen(name), name);
	if(&alias)
	{
		UnregisterCommand(alias->name);
		free(alias->command);
		free(alias->name);
		free(alias);
		return TRUE;
	}

	return FALSE;
}

int SaveAllAlias(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	ALIAS			*alias;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(alias = ght_first(alias_ht, &iterator); alias; alias = ght_next(alias_ht, &iterator))
	{
		SaveToConfigFile(alias->name, alias->command, "alias.conf");
	}

	CloseSaveFile();

	return TRUE;
}

int LoadAllAlias(void)
{
	LoadConfigFile("alias.conf");
	return TRUE;
}

int DestoryAliasTable(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	ALIAS			*alias;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(alias = ght_first(alias_ht, &iterator); alias; alias = ght_next(alias_ht, &iterator))
	{
		if(&alias)
		{
			UnregisterCommand(alias->name);
			free(alias->command);
			free(alias->name);
			free(alias);
		}
	}

	ght_finalize(alias_ht);
	return TRUE;
}

int CreateAliasTable(void)
{
	alias_ht = ght_create(100, NULL, GHT_HEURISTICS_MOVE_TO_FRONT | GHT_AUTOMATIC_REHASH);
	if(alias_ht) LoadAllAlias();

	return TRUE;
}

int ProcessAlias(char *name)
{
	/*~~~~~~~~~~~~~~~*/
	ALIAS	*alias;
	/*~~~~~~~~~~~~~~~*/

	alias = ght_get(alias_ht, strlen(name), name);
	if(alias) ProcessCommand(alias->command);

	return TRUE;
}
