/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <windowsx.h>

#include "aliasmanager.h"

#include "resource.h"
#include "ght_hash_table.h"
#include "alias.h"

extern ght_hash_table_t *alias_ht;

void PopulateListBox(HWND hwnd)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	ALIAS			*alias;
	HWND			hwndlb;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	hwndlb = GetDlgItem(hwnd, IDC_LISTNAMES);

	for(alias = ght_first(alias_ht, &iterator); alias; alias = ght_next(alias_ht, &iterator))
	{
		if(&alias)
		{
			ListBox_AddString(hwndlb, alias->name);
		}
	}
}

BOOL OnAliasCommand(HWND hwnd, WORD wNotifyCode, WORD wID, HWND hwndCtl)
{
	switch(wID)
	{
		case ID_OK:
		case ID_CANCEL:
			return EndDialog(hwnd, 0);
		case IDC_CLEAR:
			SetDlgItemText(hwnd, IDC_NAME, "");
			SetDlgItemText(hwnd, IDC_COMMAND, "");
			break;
		case IDC_SAVE:
			{
				/*~~~~~~~~~~~~~~~~~~~~~~*/
				char	name[1000];
				char	command[1000];
				int		i;
				/*~~~~~~~~~~~~~~~~~~~~~~*/

				GetDlgItemText(hwnd, IDC_NAME, name, 1000);
				GetDlgItemText(hwnd, IDC_COMMAND, command, 1000);
				i = ListBox_FindString(GetDlgItem(hwnd, IDC_LISTNAMES), 0, name);
				if(i != LB_ERR) /* update */
				{
					if(strlen(name) && strlen(command)) UpdateAlias(name, command);
				}
				else			/* append */
				{
					if(strlen(name) && strlen(command))
					{
						AddNewAlias(name, command);
						ListBox_InsertString(GetDlgItem(hwnd, IDC_LISTNAMES), -1, name);
					}
				}
			}
			break;
		case IDC_DELETE:
			{
				/*~~~~~~*/
				int i;
				/*~~~~~~*/

				i = ListBox_GetCurSel(hwndCtl);
				if(i != LB_ERR)
				{
					/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
					char	name[1000];
					ALIAS	*alias;
					HWND	hwndlb = GetDlgItem(hwnd, IDC_LISTNAMES);
					/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

					ListBox_GetText(hwndlb, i, name);
					SetDlgItemText(hwnd, IDC_NAME, "");
					SetDlgItemText(hwnd, IDC_COMMAND, "");
					alias = ght_get(alias_ht, strlen(name), name);
					if(alias)
					{
						ListBox_DeleteString(hwndlb, i);
						RemoveAlias(name);
					}
				}
			}
			break;
	}

	switch(wNotifyCode)
	{
		case LBN_SELCHANGE:
			{
				/*~~~~~~*/
				int i;
				/*~~~~~~*/

				i = ListBox_GetCurSel(hwndCtl);
				if(i != LB_ERR)
				{
					/*~~~~~~~~~~~~~~~~~~~*/
					char	name[1000];
					ALIAS	*alias;
					/*~~~~~~~~~~~~~~~~~~~*/

					ListBox_GetText(hwndCtl, i, name);
					SetDlgItemText(hwnd, IDC_NAME, name);
					alias = ght_get(alias_ht, strlen(name), name);
					if(alias)
					{
						SetDlgItemText(hwnd, IDC_COMMAND, alias->command);
						EnableWindow(GetDlgItem(hwnd, IDC_SAVE), TRUE);
					}
				}
			}
			break;
	}

	return FALSE;
}

BOOL CALLBACK AliasManagerDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
#define WM_ALIASTIMER	WM_USER + 2
	switch(uMsg)
	{
		case WM_INITDIALOG:
			PopulateListBox(hwnd);
			SetTimer(hwnd, WM_ALIASTIMER, 5, NULL);
			break;
		case WM_TIMER:
			if(wParam == WM_ALIASTIMER)
			{
				/*~~~~~~~~~~~~*/
				int i, j, k;
				/*~~~~~~~~~~~~*/

				i = SendDlgItemMessage(hwnd, IDC_NAME, WM_GETTEXTLENGTH, 0, 0);
				j = SendDlgItemMessage(hwnd, IDC_COMMAND, WM_GETTEXTLENGTH, 0, 0);
				k = ListBox_GetCurSel(GetDlgItem(hwnd, IDC_LISTNAMES));
				if(i && j)
					EnableWindow(GetDlgItem(hwnd, IDC_SAVE), TRUE);
				else
					EnableWindow(GetDlgItem(hwnd, IDC_SAVE), FALSE);
				if(i || j)
					EnableWindow(GetDlgItem(hwnd, IDC_CLEAR), TRUE);
				else
					EnableWindow(GetDlgItem(hwnd, IDC_CLEAR), FALSE);
				if(k != LB_ERR)
					EnableWindow(GetDlgItem(hwnd, IDC_DELETE), TRUE);
				else
					EnableWindow(GetDlgItem(hwnd, IDC_DELETE), FALSE);
			}
			break;
		case WM_COMMAND:
			return OnAliasCommand(hwnd, HIWORD(wParam), LOWORD(wParam), (HWND) lParam);
		case WM_CLOSE:
			return EndDialog(hwnd, 0);
	}

	return FALSE;
}
