/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <windowsx.h>
#include <Shlwapi.h>

#include "resource.h"

#include "bar.h"
#include "main.h"
#include "snap.h"
#include "configuration.h"
#include "sizefunctions.h"
#include "functionconstruction.h"
#include <shldisp.h>

#define WM_MYTIMER	(WM_USER + 3)

HWND CreateBar(void)
{
	g_bar = CreateDialog(g_inst, MAKEINTRESOURCE(IDD_BAR), g_main, (DLGPROC) BarDlgProc);
	return g_bar;
}

BOOL IsDraggerRegion(LPPOINT cp, HWND hwnd)
{
	/*~~~~~~~~~~~~~~~~~*/
	BOOL		ret;
	static HRGN hrgn;
	/*~~~~~~~~~~~~~~~~~*/

	hrgn = CreateRectRgn(0, 0, 13, bc->height);
	if(ScreenToClient(hwnd, cp)) ret = PtInRegion(hrgn, cp->x, cp->y);

	return ret;
}

void	*lpWndProcOld;

LRESULT CALLBACK EditWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_KEYDOWN:
			if(VK_RETURN == wParam)
			{
				/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/
				/* We just got a new command to do! 
				 * Do the command
				 */
				char	textportion[1000];
				/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/

				SendMessage(hwnd, WM_GETTEXT, (WPARAM) 100, (LPARAM) textportion);
				if(strlen(textportion)) ProcessCommand(textportion);

				/* Clear the box */
				SetWindowText(hwnd, "");
			}
			break;

		case WM_CHAR:
			{
				if(wParam >= 32 && wParam < 128)
				{
					/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
					char		text[256];
					int			length, start, end;
					FUNCTION	*fc;
					/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

					length = SendMessage(hwnd, WM_GETTEXTLENGTH, 0, 0);
					SendMessage(hwnd, EM_GETSEL, (WPARAM) & start, (LPARAM) & end);

					if(end >= length)
					{
						GetWindowText(hwnd, text, sizeof(text));
						text[start++] = (char)wParam;
						text[start] = 0;
						if((fc = GuessCommand(text)))
						{
							if(fc->FunctionName[0] == text[0])
							{
								SendMessage(hwnd, WM_SETTEXT, 0, (LPARAM) fc->FunctionName);
								SendMessage(hwnd, EM_SETSEL, start, -1);
								return 0;
							}
						}
					}
				}
			}
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
			}
			break;
	}

	return CallWindowProc(lpWndProcOld, hwnd, message, wParam, lParam);
}

LRESULT CALLBACK BarDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	/*~~~~~~~~~~~~~~~*/
	LRESULT result;
	/*~~~~~~~~~~~~~~~*/

	switch(uMsg)
	{
		case WM_INITDIALOG:
			{
				g_bar = hDlg;
				LoadLookFromBARCONFIG(hDlg);
				UpdateEditBoxSize(hDlg);
				lpWndProcOld = (void *)GetWindowLong(GetDlgItem(hDlg, IDC_COMMAND), GWL_WNDPROC);
				SetWindowLongPtr(GetDlgItem(hDlg, IDC_COMMAND), GWL_WNDPROC, (LONG) EditWndProc);
				if((S_OK != SHAutoComplete(GetDlgItem(hDlg, IDC_COMMAND), SHACF_DEFAULT)))
					MessageBox(g_bar, "SHAutoComplete Failed", "SHAutoComplete Failed", MB_ICONWARNING);

				SetTimer(hDlg, WM_MYTIMER, 10, NULL);
			}
			break;

		case WM_TIMER:
			if(wParam == WM_MYTIMER)
			{
				if(hDlg != GetForegroundWindow() && bc->autorollup) SetRollup(hDlg, TRUE);

				if(hDlg != GetForegroundWindow() && bc->automin)
				{
					ShowWindow(hDlg, SW_HIDE);
				}
			}
			break;

		case WM_HOTKEY:
			switch(wParam)
			{
				case ID_MYHOTKEY:
					{
						/*~~~~~~~~~~~*/
						int		i;
						RECT	rc;
						/*~~~~~~~~~~~*/

						i = IsWindowVisible(g_bar);
						if(!i) ShowWindow(g_bar, TRUE);

						GetWindowRect(hDlg, &rc);
						i = (rc.right - rc.left);
						if(i == 14)
						{
							SetRollup(g_bar, FALSE);
							SetForegroundWindow(g_bar);
						}

						if(i != 14 && bc->autorollup)
							SetRollup(g_bar, TRUE);
						else
							SetForegroundWindow(g_bar);
					}
					break;
			}
			break;

		case WM_PAINT:
			{
				/*~~~~~~~~~~~~~~*/
				/* Draw gripper */
				RECT	rect1;
				RECT	rect2;
				/*~~~~~~~~~~~~~~*/

				/* start x, start y,width,height */
				SetRect(&rect1, 3, 2, 5, bc->height - 5);
				DrawEdge(GetDC(hDlg), &rect1, BDR_RAISEDINNER, BF_RECT | BF_LEFT | BF_RIGHT);
				SetRect(&rect2, 7, 2, 9, bc->height - 5);
				DrawEdge(GetDC(hDlg), &rect2, BDR_RAISEDINNER, BF_RECT | BF_LEFT | BF_RIGHT);
			}
			break;

		case WM_SETCURSOR:
			{
				/*~~~~~~~~~~~~~~~*/
				POINT	pt;
				HCURSOR cursor;
				/*~~~~~~~~~~~~~~~*/

				GetCursorPos(&pt);
				if(IsDraggerRegion(&pt, hDlg))
				{
					cursor = LoadCursor(NULL, IDC_HAND);
					if(cursor) SetCursor(cursor);
				}
			}

			return TRUE;

		case WM_NCHITTEST:
			result = DefWindowProc(hDlg, uMsg, wParam, lParam);
			if(result == HTCLIENT) result = HTCAPTION;
			SetWindowLong(hDlg, DWL_MSGRESULT, (LONG) result);
			return TRUE;

		case WM_NCLBUTTONDBLCLK:
			ToggleRollup(hDlg);
			break;

		case WM_MOVING:
			OnMoving(hDlg, (LPRECT) lParam);
			break;

		case WM_ENTERSIZEMOVE:
			OnEnterSizeMove(hDlg);
			break;

		case WM_WINDOWPOSCHANGED:
			UpdateEditBoxSize(hDlg);
			break;

		case WM_NCRBUTTONUP:	/* Did the user right click? */
			{
				/*~~~~~~~~~~~~~~~~~~~~~~*/
				/* Pop up the menu. */
				POINT			mp;
				static HMENU	hMenu;
				/*~~~~~~~~~~~~~~~~~~~~~~*/

				if(!hMenu)
				{
					hMenu = LoadMenu(g_inst, MAKEINTRESOURCE(IDM_TRAY));
					hMenu = GetSubMenu(hMenu, 0);
				}

				GetCursorPos(&mp);
				TrackPopupMenu(hMenu, 0, mp.x, mp.y, 0, g_main, 0);
				if(bc->ontop)
					CheckMenuItem(hMenu, ID_OPTIONS_ALWAYSONTOP, MF_BYCOMMAND | MF_CHECKED);
				else
					CheckMenuItem(hMenu, ID_OPTIONS_ALWAYSONTOP, MF_BYCOMMAND | MF_UNCHECKED);
			}
			break;
	}

	return FALSE;
}
