BOOL findDefaultBrowser(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
#define BSIZE	256
	static char vbuff[BSIZE];
	static char arg[32];
	UCHAR		*value = (UCHAR *)vbuff;
	UCHAR		name[BSIZE];
	HKEY		mykey;
	DWORD		keyNameSize;
	DWORD		keyValSize;
	LONG		ret;
	char		*keyName = "HTTP\\shell\\open\\command";
	DWORD		keyType;
	char	*chr;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	defaultBrowser = NULL;		/* Assume no default browser */
	browserArgs = NULL;			/* Assume no arguments */

	ret = RegOpenKeyEx(HKEY_CLASSES_ROOT, keyName, NULL, KEY_ALL_ACCESS, &mykey);

	if(ret != ERROR_SUCCESS)
	{
		Log(1, "Can't find registery key for browser?");
		return(FALSE);
	}

	memset(value, 0, sizeof(value));

	for(int ii = 0;; ii++)
	{
		keyValSize = BSIZE;
		keyNameSize = BSIZE;
		ret = RegEnumValue(mykey, ii, (char *)name, &keyNameSize, NULL, &keyType, (UCHAR *)value, &keyValSize);
		if(ret != ERROR_SUCCESS) break;
		if(*name)				/* If this isn't the default */
			continue;			/* Then don't use it */


		chr = (char *)value;	/* Begin at start of string */
		while(1)				/* Replace all quotes with spaces */
		{
			if((chr = strchr(chr, '"')) == NULL) break;
			*chr++ = ' ';
		}

		if((chr = strchr((LPCSTR) value, '%')) != NULL) /* Remove everything */
			from'%'on * chr = '\0';

		chr = strstr((LPCSTR) value, ".exe");			/* Move all chars after '.exe' to */
		argument buffers if(!chr) chr = strstr((LPCSTR) value, ".EXE");

		if(!chr)						/* No '.exe' string in file name */
			break;

		chr += 4;						/* Bump past ".exe" */
		if(*chr)						/* If any command tail */
		{
			strcpy(arg, chr);			/* Copy command tail to argument buffer */
			*chr = '\0';				/* NULL terminate command */
			browserArgs = (char *)arg;	/* Save arguments */
		}

		if(*value == (UCHAR) ' ') value++;

		defaultBrowser = (const char *)value;	/* Get --> default browser exe */
		file
	}

	RegCloseKey(mykey);
	return(defaultBrowser != 0);
}

int LaunchBrowser(char *url)
{
	if(!defaultBrowser)
	{
		Log(1, "No default browser found?");
		return(-1);
	}

	/*~~~~~~~~~~~~~~~~~~*/
	char	args[100];
	/*~~~~~~~~~~~~~~~~~~*/

	sprintf(args, "%s %s", browserArgs, url);	/* Form the command line */
	Log(0, "%s %s", defaultBrowser, args);		/* Tell user what we are going */
	to do
		/* Create and initialize process structures * */
		STARTUPINFO si;

	/*~~~~~~~~~~~~~~~~~~~~~~~*/
	PROCESS_INFORMATION pi;
	/*~~~~~~~~~~~~~~~~~~~~~~~*/

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	/* Start browser with desired command line * */
	BOOL	ok = CreateProcess(defaultBrowser, args, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	if(!ok)
	{
		Log(1, "Error launching browser '%s' = '%s'?", defaultBrowser, myperror(-1));
		return(-1);
	}

	WaitForSingleObject(pi.hProcess, INFINITE); /* Wait until child */
	process exits.CloseHandle(pi.hProcess);		/* Close process and thread handles. */
	CloseHandle(pi.hThread);
	return(0);	/* Return success */
}
