/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <string.h>
#include <windows.h>

#include "configfile.h"
#include "main.h"
#include "alias.h"
#include "macro.h"
#include "functionconstruction.h"
#include "stringfunctions.h"

#define MAX_LINE_SIZE	4096
#define MAX_STRING_SIZE 256

char	ConfigFile[MAX_PATH];
FILE	*sfp;

int TrimLine(char *line)
{
	TrimCRLF(line);
	TrimWhiteSpace(line);
	StripComments(line);
	return TRUE;
}

int ParseConfigLine(char *line, int lineNum, char *filename)
{
	/*~~~~~~~~~~~~~~~~~*/
	char	*fp, *sp;
	/*~~~~~~~~~~~~~~~~~*/

	fp = strtok(line, "=");
	sp = strtok(NULL, "=");

	if(fp && sp && strstr(filename, "alias"))
	{
		AddNewAlias(fp, sp);
		return TRUE;
	}
	else
	{
		AddNewMacro(fp, sp);
		return TRUE;
	}

	return FALSE;
}

int ReadLine(char *buff, int maxLen, FILE *fp)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~*/
	char	*tmp, *p = buff;
	int		NumRead = 0;
	/*~~~~~~~~~~~~~~~~~~~~~~~~*/

	*buff = '\0';

	while(1)
	{
		if(!fgets(p, maxLen - strlen(buff), fp)) break;
		++NumRead;
		TrimLine(p);
		if(0 == strlen(p)) break;

		tmp = p + strlen(p) - 1;
		if('\\' != *tmp) break;

		*tmp = '\0';
		p = tmp;
		continue;
	}

	return NumRead;
}

FILE *OpenConfigFile(char *param, char *filename)
{
	/*~~~~~~~~~~~~~~~~~~~*/
	FILE	*fp = NULL;
	char	*p;
	/*~~~~~~~~~~~~~~~~~~~*/

	GetModuleFileName(g_inst, ConfigFile, sizeof(ConfigFile));
	p = ConfigFile;
	while(strchr(p, '\\'))
	{
		p = strchr(p, '\\');
		p++;
	}

	*p = '\0';

	strcat(ConfigFile, filename);

	fp = fopen(ConfigFile, param);
	if(!fp)
	{
		return NULL;
	}

	return fp;
}

int CloseSaveFile(void)
{
	if(sfp) fclose(sfp);

	return TRUE;
}

int SaveToConfigFile(char *name, char *data, char *filename)
{
	/*~~~~~~~~~~~*/
	char	*p;
	/*~~~~~~~~~~~*/

	p = malloc(strlen(name) + strlen(data) + 5);
	if(!p) return FALSE;

	strcpy(p, name);
	strcat(p, "=");
	strcat(p, data);
	strcat(p, "\n");
	strcat(p, "\0");

	sfp = OpenConfigFile("w", filename);
	fclose(sfp);
	sfp = OpenConfigFile("a+", filename);

	if(sfp)
	{
		fwrite(p, sizeof(char), strlen(p), sfp);
		return TRUE;
	}
	else
		return FALSE;
}

int LoadConfigFile(char *filename)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char	line[MAX_LINE_SIZE];
	int		LineNum = 0, NumRead = 0;
	FILE	*fp = OpenConfigFile("a+", filename);
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	if(fp)
	{
		while(0 != (NumRead = ReadLine(line, MAX_LINE_SIZE, fp)))
		{
			LineNum += NumRead;
			if(IsBlankLine(line)) continue;
			ParseConfigLine(line, LineNum, filename);
		}

		fclose(fp);
		return TRUE;
	}

	return FALSE;
}
