/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <Shlwapi.h>

#include "dllroutines.h"
#include "main.h"
#include "sllist.h"

SLLIST	*PluginList = NULL;
SLLIST	*Removed = NULL;

char *GetPluginPath(void)
{
	/*~~~~~~~~~~~~~~*/
	char	*path;
	/*~~~~~~~~~~~~~~*/

	path = GlobalAlloc(GPTR, MAX_PATH);
	if(path)
	{
		GetModuleFileName(g_inst, path, MAX_PATH);
		PathRemoveFileSpec(path);
		strcat(path, "\\plugins\\");
	}

	return path;
}

int LoadPluginsFromList(int Tag, void *Memory, void *Args)
{
	/*~~~~~~~~~~~~~~~~~~~~*/
	PLUGIN			*p;
	BarCommandInit	bci;
	/*~~~~~~~~~~~~~~~~~~~~*/

	p = Memory;
	p->hi = LoadLibrary(p->location);
	bci = (BarCommandInit) GetProcAddress(p->hi, "BarCommandInit");
	if(bci) bci(g_inst, g_bar);
	return 0;				/* Continue with loading of dlls */
}

int UnloadPluginsFromList(int Tag, void *Memory, void *Args)
{
	/*~~~~~~~~~~~~~~~~~~~~*/
	PLUGIN			*p;
	BarCommandExit	bce;
	/*~~~~~~~~~~~~~~~~~~~~*/

	p = Memory;
	bce = (BarCommandExit) GetProcAddress(p->hi, "BarCommandExit");
	if(bce) bce();
	FreeLibrary(p->hi);
	return 0;				/* Continue with unloading dlls */
}

void RemoveAllPlugins(void)
{
	SLWalk(PluginList, UnloadPluginsFromList, 0);
}


void AddPluginToList(char *filename)
{
	/*~~~~~~~~~~~~~~*/
	char	*path;
	PLUGIN	p;
	/*~~~~~~~~~~~~~~*/

	path = GetPluginPath();
	strcat(path, filename); /* Path now has full path name to dll */
	p.location = path;
	p.name = filename;
	p.hi = NULL;

	SLAppend(&PluginList, 0, &p, sizeof p);
}

void UnloadPlugins(void)
{
	SLWalk(PluginList, UnloadPluginsFromList, 0);
}

/* - Called at start of program.
   - Searches ./plugin/ directory for *.dlls.
   - Adds them to PluginList (SLL)
   - Calls LoadPluginsFromList
 */
void LoadPlugins(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	WIN32_FIND_DATA fd;
	HANDLE			hFind = NULL;
	char			*path = NULL;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	path = GetPluginPath();

	hFind = FindFirstFile(strcat(path, "*.dll"), &fd);
	if(hFind != INVALID_HANDLE_VALUE)
	{
		if(fd.dwFileAttributes != FILE_ATTRIBUTE_DIRECTORY)
		{
			AddPluginToList(fd.cFileName);
		}

		while(FindNextFile(hFind, &fd) == TRUE)
		{
			if(fd.dwFileAttributes != FILE_ATTRIBUTE_DIRECTORY) AddPluginToList(fd.cFileName);
		}

		FindClose(hFind);
	}

	SLWalk(PluginList, LoadPluginsFromList, 0);

	GlobalFree(path);
}
