/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <Shlwapi.h>

#include "functionconstruction.h"
#include "ght_hash_table.h"
#include "main.h"
#include "corefunctions.h"
#include "browse.h"
#include "xstrtok.h"
#include "configuration.h"

ght_hash_table_t	*ht;
pFunction			fp;

int					listcommands(char *command);	/* Temp dec, listcommands is just a temp function! */

void CreateFunctionTable(void)
{
	ht = ght_create(100, NULL, GHT_HEURISTICS_MOVE_TO_FRONT | GHT_AUTOMATIC_REHASH);
	PopulateFunctionTable();
}

void PopulateFunctionTable(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	/* Insert our functions into the hash table */
	static FUNCTION fc[] =
	{
		{ "@", alias, 0 },
		{ "#", macro, 0 },
		{ "browse", browse, 0 },
		{ "dissapear", hidebar, 0 },
		{ "exit", exitbar, 0 },
		{ "hide", hidebar, 0 },
		{ "listcommands", listcommands, 0 },
		{ "minimize", hidebar, 0 },
		{ "options", options, 0 },
		{ "desktop", desktop, 0 },
		{ "about", about, 0 }
	};
	size_t			num_func = sizeof fc / sizeof fc[0];
	size_t			i;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	if(ht)
	{
		for(i = 0; i < num_func; i++)
		{
			/*~~~~~~*/
			int r;
			/*~~~~~~*/

			r = ght_insert(ht, fc + i, sizeof(char) * strlen(fc[i].FunctionName), fc[i].FunctionName);
			if(r != 0)	/* failure */
				MessageBox(g_bar, "Failed to insert into hash table", "ERROR:", MB_ICONERROR);
		}
	}
	else
		MessageBox(g_bar, "Failed to create hash table", "ERROR:", MB_ICONERROR);
}

void DestroyFunctionTable(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	FUNCTION		*fc;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(fc = ght_first(ht, &iterator); fc; fc = ght_next(ht, &iterator))
	{
		if(fc->freeme)
		{
			free(fc->FunctionName);
			free(fc);
		}
	}

	ght_finalize(ht);
}

/*
 =======================================================================================================================
    listcommands is just a temp function!
 =======================================================================================================================
 */
int listcommands(char *command)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	FUNCTION		*fc;
	char			commands[1000] = { 0 };
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(fc = ght_first(ht, &iterator); fc; fc = ght_next(ht, &iterator))
	{
		strcat(commands, fc->FunctionName);
		strcat(commands, " ");
	}

	MessageBox(g_bar, commands, commands, MB_OK);
	return TRUE;
}

__declspec(dllexport)
int RegisterCommand(char *name, pFunction fp)	/* Exported (used in sdk for DLL's) */
{
	/*~~~~~~~~~~~~~~~~*/
	FUNCTION	*fc;
	/*~~~~~~~~~~~~~~~~*/

	if(name && fp)
	{
		fc = (FUNCTION *)malloc(sizeof(FUNCTION));

		fc->fp = fp;
		fc->FunctionName = malloc(strlen(name) + 1);
		strcpy(fc->FunctionName, name);
		fc->freeme = 1;
		if(ght_insert(ht, fc, sizeof(char) * strlen(name), name) == 0)
		{
			return TRUE;	/* Success */
		}
		else
		{
			return 0;		/* Failure */
		}
	}
	else
		return 0;
}

__declspec(dllexport)
int UnregisterCommand(char *name)	/* Exported (used in sdk for DLL's) */
{
	/*~~~~~~~~~~~~~~~~*/
	FUNCTION	*fc;
	/*~~~~~~~~~~~~~~~~*/

	fc = ght_remove(ht, strlen(name), name);
	if(fc)
	{
		if(fc->freeme)
		{
			free(fc->FunctionName);
			free(fc);
		}

		return TRUE;	/* Success */
	}
	else
		return 0;		/* Failed to remove, most likely reason: the entry didnt exist */

	return TRUE;
}

FUNCTION *GuessCommand(char *command)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	FUNCTION		*fc;
	char			commands[1000] = { 0 };
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	/* Please note: I am well, well aware, that a comparison like this, is not a fast
	 * way to do things. I was going to use a ternary search tree, but then I did some
	 * testing... I loaded 8000 aliase, and watched the performance. You couldn't
	 * notice it, you might as well have had one alias. Now serisouly, who the hell is
	 * going to have 8000 aliases? If you show me your 8000+ alias list, then I'll
	 * code up a ternary search tree, JUST FOR YOU!!
	 */
	for(fc = ght_first(ht, &iterator); fc; fc = ght_next(ht, &iterator))
	{
		if(StrCmpNI(fc->FunctionName, command, strlen(command)) == 0)
		{
			return fc;
		}
	}

	return NULL;
}

int ExecuteInDosWindow(char *data)
{
	/*~~~~~~~~~~~~~~~~~~~*/
	char	temp[1000];
	/*~~~~~~~~~~~~~~~~~~~*/

	strcpy(temp, "cmd.exe");
	if(strlen(data))
	{
		strcat(temp, " ");
		strcat(temp, "/K");
		strcat(temp, " ");
		strcat(temp, data);
	}

	WinExec(temp, SW_NORMAL);
	return TRUE;
}

int Execute(char *data)
{
	/*~~~~~~~~~~~~~~*/
	int		i = 0;
	char	*p;
	/*~~~~~~~~~~~~~~*/

	/* Do they want a dos prompt execution? */
	if(data[0] == '!')
	{
		p = data;
		p++;
		ExecuteInDosWindow(p);
		return TRUE;
	}

	/* An URL perhaps? Or maybe its a path-to-file */
	if(bc->newwindow)
	{
		/*~~~~~~~~~~~~~~*/
		char	*temp;
		/*~~~~~~~~~~~~~~*/

		temp = malloc(strlen(data) + 7);
		strcpy(temp, " -new ");
		strcat(temp, data);

		i = (int)ShellExecute(g_bar, "open", "iexplore.exe", temp, NULL, SW_SHOWNORMAL);
		if(i < 32) 
			i = (int)ShellExecute(g_bar, "open", data, NULL, NULL, SW_SHOWNORMAL);
	}
	else
		i = (int)ShellExecute(g_bar, "open", data, NULL, NULL, SW_SHOWNORMAL);

	/* Maybe its in the system path, and needs executing */
	if(i < 32)			/* Failed */
	{
		/*~~~~~~~~~~~~~~~~~~~~~~~*/
		char	temp[MAX_PATH];
		/*~~~~~~~~~~~~~~~~~~~~~~~*/

		strcpy(temp, PathGetArgs(data));
		PathRemoveArgs(data);
		PathQuoteSpaces(data);
		strcat(data, " ");
		strcat(data, temp);
		WinExec(data, SW_SHOWNORMAL);
		return TRUE;
	}
	else
		return TRUE;

	return 0;
}

/*
 =======================================================================================================================
    This function is where all the action takes place. It decides what type of command we're dealing with and responds
    ;-)
 =======================================================================================================================
 */
int ProcessCommand(char *data)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	FUNCTION	*fc;
	XSTRTOK		xs;
	char		first_part[1000];
	char		*p;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	strcpy(first_part, data);
	xs.delim = " ";
	xs.quote = 1;
	xs.str2parse = first_part;

	p = xstrtok(&xs);

	strcat(p, "\0");

	fc = ght_get(ht, strlen(first_part), first_part);	/* Lookup */
	if(fc)					/* Found */
	{
		fp = fc->fp;
		if(fp) fp(data);	/* Execute function pointer */
		return TRUE;
	}

	if(data[0] == '@')		/* Alias */
	{
		fc = ght_get(ht, strlen("@"), "@"); /* Lookup */
		if(fc)					/* Found */
		{
			fp = fc->fp;
			if(fp) fp(data);	/* Execute function pointer (Process Alias - corefunctions.h) */
			return TRUE;
		}
	}

	if(data[0] == '#')			/* Macro */
	{
		fc = ght_get(ht, strlen("#"), "#"); /* Lookup */
		if(fc)					/* Found */
		{
			fp = fc->fp;
			if(fp) fp(data);	/* Execute function pointer (Process Macro - corefunctions.h) */
			return TRUE;
		}
	}

	/* Assume its a shell-execution (URL, path etc) */
	return Execute(data);
}
