#ifndef FUNCTIONS_H
	#define FUNCTIONS_H
typedef int (*pFunction) (char *);
typedef struct
{
	char		*FunctionName;
	pFunction	fp;
	int			freeme;
} FUNCTION;

void		PopulateFunctionTable(void);
void		CreateFunctionTable(void);

FUNCTION	*GuessCommand(char *);
int			ProcessCommand(char *);
void		DestroyFunctionTable(void);
int			AddFunctionToTable(FUNCTION *);

__declspec(dllexport)
int RegisterCommand(char *, pFunction);
__declspec(dllexport)
int UnregisterCommand(char *);
#endif FUNCTIONS_H
