/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include "macro.h"
#include "configuration.h"
#include "functionconstruction.h"
#include "ght_hash_table.h"
#include "main.h"
#include "stringfunctions.h"
#include "configfile.h"
#include "xstrtok.h"

ght_hash_table_t	*macro_ht;

int UpdateMacro(char *name, char *command)
{
	if(RemoveMacro(name)) AddNewMacro(name, command);

	return TRUE;
}

int AddNewMacro(char *name, char *command)
{
	/*~~~~~~~~~~~~~~~*/
	MACRO	*macro;
	/*~~~~~~~~~~~~~~~*/

	macro = (MACRO *)malloc(sizeof(MACRO));
	macro->name = _strdup(name);
	macro->command = _strdup(command);

	if(macro->name && macro->command)
	{
		if(ght_insert(macro_ht, macro, sizeof(char) * strlen(macro->name), macro->name) == 0)
		{
			if(RegisterCommand(name, ProcessMacro)) return TRUE;	/* Success */
		}
	}

	return FALSE;
}

int RemoveMacro(char *name)
{
	/*~~~~~~~~~~~~~~~*/
	MACRO	*macro;
	/*~~~~~~~~~~~~~~~*/

	macro = ght_remove(macro_ht, strlen(name), name);
	if(&macro)
	{
		/*~~~~~~~~~~*/
		int i = 0;
		/*~~~~~~~~~~*/

		UnregisterCommand(macro->name);
		free(macro->command);
		free(macro->name);
		free(macro);
		return TRUE;
	}

	return FALSE;
}

int SaveAllMacro(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	MACRO			*macro;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(macro = ght_first(macro_ht, &iterator); macro; macro = ght_next(macro_ht, &iterator))
	{
		SaveToConfigFile(macro->name, macro->command, "macro.conf");
	}

	CloseSaveFile();

	return TRUE;
}

int LoadAllMacro(void)
{
	LoadConfigFile("macro.conf");
	return TRUE;
}

int DestoryMacroTable(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	ght_iterator_t	iterator;
	MACRO			*macro;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(macro = ght_first(macro_ht, &iterator); macro; macro = ght_next(macro_ht, &iterator))
	{
		if(&macro)
		{
			UnregisterCommand(macro->name);
			free(macro->command);
			free(macro->name);
			free(macro);
		}
	}

	ght_finalize(macro_ht);
	return TRUE;
}

int CreateMacroTable(void)
{
	macro_ht = ght_create(100, NULL, GHT_HEURISTICS_MOVE_TO_FRONT | GHT_AUTOMATIC_REHASH);
	if(macro_ht) LoadAllMacro();

	return TRUE;
}

int ProcessMacro(char *name)
{
	/*~~~~~~~~~~~~~~~*/
	MACRO	*macro;
	XSTRTOK xs;
	char	*p;
	/*~~~~~~~~~~~~~~~*/

	macro = ght_get(macro_ht, strlen(name), name);
	if(macro)
	{
		xs.delim = "&";
		xs.quote = 0;
		xs.str2parse = macro->command;

		p = xstrtok(&xs);
		while(p != NULL)
		{
			TrimWhiteSpace(p);
			ProcessCommand(p);
			p = xstrtok(&xs);
		}
	}

	return TRUE;;
}
