/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <commctrl.h>

#include "resource.h"

#include "taskbar.h"
#include "bar.h"
#include "configuration.h"
#include "sizefunctions.h"
#include "options.h"
#include "functionconstruction.h"
#include "dllroutines.h"
#include "alias.h"
#include "aliasmanager.h"
#include "macro.h"
#include "about.h"

HINSTANCE	g_inst;
HWND		g_bar = 0;
HWND		g_main = 0;

void SetSystemHotKey(void)
{
	RegisterHotKey(g_bar, ID_MYHOTKEY, HIBYTE(bc->wHotkey), LOBYTE(bc->wHotkey));
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	/*~~~~~~~~~~~~~~~~~~*/
	HMENU	hMenu = 0;
	/*~~~~~~~~~~~~~~~~~~*/

	switch(msg)
	{
		case WM_CREATE:
			/* Loads saved config into global bcfg struct */
			bc = ReadConfig();
			/* Creates the actual bar itself */
			CreateBar();
			/* Loads the hot-key from the config, registers it */
			SetSystemHotKey();
			/* Creates a hash table, and populates with default functions */
			CreateFunctionTable();
			/* Creates the alias tables, and registers there functions */
			CreateAliasTable();
			/* Creates the macro table, and registers there functions */
			CreateMacroTable();
			/* Loads plugins, and registers there functions */
			LoadPlugins();
			break;

		/* This menu is shared by the tray, and the right click menu */
		case WM_COMMAND:
			switch(wParam)
			{
				case ID_EXIT:
					SaveLookInBARCONFIG();
					DestroyWindow(hwnd);
					break;
				case ID_HIDESHOW:
					ToggleHidden();
					SetRollup(g_bar, FALSE);
					break;
				case ID_OPTIONS:
					DoPropertySheet(g_bar);
					break;
				case ID_ALIASMANAGER:
					DialogBox(g_inst, MAKEINTRESOURCE(IDD_ALIASMANAGER), g_bar, AliasManagerDlgProc);
					break;
				case ID_ABOUT:
					DialogBox(g_inst, MAKEINTRESOURCE(IDD_ABOUT), g_bar, AboutDlgProc);
					break;
			}

			return TRUE;

		case WM_DESTROY:
			WriteConfig(bc);
			FreeConfig(bc);
			ShowWindow(g_bar, FALSE);
			MyTaskBarDeleteIcon(hwnd, UWM_SYSTRAY);
			RemoveAllPlugins();
			SaveAllAlias();
			DestoryAliasTable();
			SaveAllMacro();
			DestoryMacroTable();
			DestroyFunctionTable(); /* Order very important! */
			PostQuitMessage(0);
			return TRUE;

		case UWM_SYSTRAY:
			switch(lParam)
			{
				case WM_RBUTTONUP:	/* Did the user right click? */
					{
						/*~~~~~~~~~~~*/
						/* Pop up the menu. */
						POINT	mp;
						/*~~~~~~~~~~~*/

						if(!hMenu) hMenu = LoadMenu(g_inst, MAKEINTRESOURCE(IDM_TRAY));

						GetCursorPos(&mp);
						SetForegroundWindow(hwnd);
						TrackPopupMenu(GetSubMenu(hMenu, 0), 0, mp.x, mp.y, 0, hwnd, 0);
					}
					break;

				case WM_LBUTTONUP:
					SetForegroundWindow(hwnd);
					if(!g_bar)		/* Set by the BarDlgProc (hwnd if running) */
						CreateBar();
					else
						ToggleHidden();

					break;
			}

			return TRUE;
	}

	return DefWindowProc(hwnd, msg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	HWND		hwnd;
	WNDCLASSEX	wc;
	MSG			msg;
	char		*classname = "Noise42.NOTIFYICONDATA.hWnd";
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	g_inst = hInstance;

	SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS);

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = 0;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MYICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = classname;
	wc.hIconSm = LoadImage
		(
			hInstance,
			MAKEINTRESOURCE(IDI_MYICON),
			IMAGE_ICON,
			GetSystemMetrics(SM_CXSMICON),
			GetSystemMetrics(SM_CYSMICON),
			0
		);
	RegisterClassEx(&wc);

	CoInitialize(NULL);
	InitCommonControls();

	g_main = hwnd = CreateWindowEx
		(
			WS_EX_APPWINDOW,
			classname,
			classname,
			WS_POPUP,
			CW_USEDEFAULT,
			0,
			CW_USEDEFAULT,
			0,
			NULL,
			NULL,
			hInstance,
			NULL
		);

	MyTaskBarAddIcon(hwnd, UWM_SYSTRAY, LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MYICON)), "Tip");

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	CoUninitialize();

	return (int)msg.wParam;
}
