/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>
#include <commctrl.h>
#include <prsht.h>

#include "options.h"
#include "configuration.h"
#include "resource.h"
#include "main.h"
#include "bar.h"
#include "sizefunctions.h"

bcfg	bc_old;

void LoadHotKeyDlg(HWND hDlg, bcfg *bc)
{
	if(bc->wHotkey) SendDlgItemMessage(hDlg, IDC_HOTKEY, HKM_SETHOTKEY, (WPARAM) bc->wHotkey, 0);
}

void SaveHotKeyDlg(HWND hDlg, bcfg *bc)
{
	/*~~~~~~~~~~~*/
	WORD	hk;
	/*~~~~~~~~~~~*/

	hk = (WORD) SendDlgItemMessage(hDlg, IDC_HOTKEY, HKM_GETHOTKEY, 0, 0);
	if(bc->wHotkey != hk)
	{
		bc->wHotkey = hk;
		SetSystemHotKey();
	}
}

void RevertHotKeyDlg(bcfg *bc, bcfg *bc_old)
{
	bc = bc_old;
}

BOOL APIENTRY HotKeyDialogProc(HWND hDlg, UINT message, UINT wParam, LONG lParam)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	static PROPSHEETPAGE	*ps;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	switch(message)
	{
		case WM_INITDIALOG:
			/* Save the PROPSHEETPAGE information. */
			ps = (PROPSHEETPAGE *)lParam;
			LoadHotKeyDlg(hDlg, bc);
			return TRUE;

		case WM_NOTIFY:
			switch(((NMHDR FAR *) lParam)->code)
			{
				case PSN_SETACTIVE:
					/* Initialize the controls. */
					break;

				case PSN_APPLY:
					{
						SaveHotKeyDlg(hDlg, bc);
						SetWindowLong(hDlg, DWL_MSGRESULT, TRUE);
					}
					break;

				case PSN_KILLACTIVE:
					SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
					break;

				case PSN_RESET:
					/* Reset to the original values. */
					RevertHotKeyDlg(bc, &bc_old);
					SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
					break;
			}
	}

	return FALSE;
}

void LoadAppearenceDlg(HWND hDlg, bcfg *bc)
{
	if(bc->ontop) CheckDlgButton(hDlg, IDC_ALWAYSONTOP, TRUE);
	if(bc->animated) CheckDlgButton(hDlg, IDC_ANIMATED, TRUE);
	if(bc->autorollup) CheckDlgButton(hDlg, IDC_AUTOROLLUP, TRUE);
	if(bc->automin) CheckDlgButton(hDlg, IDC_AUTOMINIMIZE, TRUE);
	if(bc->alttab) CheckDlgButton(hDlg, IDC_ALTTAB, TRUE);
	if(bc->newwindow) CheckDlgButton(hDlg, IDC_NEWWINDOW, TRUE);
	SetDlgItemInt(hDlg, IDC_WIDTH, bc->width, FALSE);
	SendDlgItemMessage(hDlg, IDC_SWIDTH, UDM_SETRANGE, 0, (LPARAM) (0, 800));
	SendDlgItemMessage(hDlg, IDC_SHEIGHT, UDM_SETRANGE, 0, (LPARAM) (0, 800));
	SendDlgItemMessage(hDlg, IDC_SWIDTH, UDM_SETPOS, 0, (LPARAM) bc->width);
	SendDlgItemMessage(hDlg, IDC_SHEIGHT, UDM_SETPOS, 0, (LPARAM) bc->height);
}

void SaveAppearenceDlg(HWND hDlg, bcfg *bc)
{
	/*~~~~~~~~~~~*/
	int		i;
	RECT	rc;
	/*~~~~~~~~~~~*/

	GetWindowRect(g_bar, &rc);
	i = (rc.right - rc.left);
	bc->width = GetDlgItemInt(hDlg, IDC_WIDTH, NULL, FALSE);
	bc->height = GetDlgItemInt(hDlg, IDC_HEIGHT, NULL, FALSE);
	if(i > 14)
		SetRollup(g_bar, FALSE);
	else
		SetRollup(g_bar, TRUE);

	if(IsDlgButtonChecked(hDlg, IDC_ALWAYSONTOP))
	{
		bc->ontop = TRUE;
		SetWindowPos(g_bar, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	}
	else
	{
		bc->ontop = FALSE;
		SetWindowPos(g_bar, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	}

	if(IsDlgButtonChecked(hDlg, IDC_ANIMATED))
		bc->animated = TRUE;
	else
		bc->animated = FALSE;

	if(IsDlgButtonChecked(hDlg, IDC_AUTOROLLUP))
		bc->autorollup = TRUE;
	else
		bc->autorollup = FALSE;

	if(IsDlgButtonChecked(hDlg, IDC_AUTOMINIMIZE))
		bc->automin = TRUE;
	else
		bc->automin = FALSE;
		
		

	/* This was ment to be an option to either show in alt+tab or not show in alt+tab.
		 But there is no way to do this (as far as i know!), and all my attempts failed :(
		 I'll leave this here in case I find a way
	
	if(IsDlgButtonChecked(hDlg, IDC_ALTTAB))
	{
		bc->alttab = TRUE;
		ShowWindow(g_bar,SW_HIDE);
		SetWindowLong(g_bar, GWL_EXSTYLE, WS_EX_TOPMOST);
		ShowWindow(g_bar,SW_SHOW);
	}
	else
	{
		bc->alttab = FALSE;
		ShowWindow(g_bar,SW_HIDE);
		SetWindowLong(g_bar, GWL_EXSTYLE, WS_EX_TOOLWINDOW);
		ShowWindow(g_bar,SW_SHOW);
	}*/

	if(IsDlgButtonChecked(hDlg, IDC_NEWWINDOW))
		bc->newwindow = TRUE;
	else
		bc->newwindow = FALSE;
}

void RevertAppearenceDlg(bcfg *bc, bcfg *bc_old)
{
	bc = bc_old;
}

BOOL APIENTRY AppearenceDialogProc(HWND hDlg, UINT message, UINT wParam, LONG lParam)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	static PROPSHEETPAGE	*ps;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	switch(message)
	{
		case WM_INITDIALOG:
			/* Save the PROPSHEETPAGE information. */
			ps = (PROPSHEETPAGE *)lParam;
			LoadAppearenceDlg(hDlg, bc);
			return TRUE;

		case WM_NOTIFY:
			switch(((NMHDR FAR *) lParam)->code)
			{
				case PSN_SETACTIVE:
					SetWindowLong(hDlg, DWL_MSGRESULT, TRUE);
					break;

				case PSN_APPLY:
					SaveAppearenceDlg(hDlg, bc);
					SetWindowLong(hDlg, DWL_MSGRESULT, TRUE);
					break;

				case PSN_KILLACTIVE:
					SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
					break;

				case PSN_RESET:
					/* Reset to the original values. */
					RevertAppearenceDlg(bc, &bc_old);
					SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
					break;
			}
	}

	return FALSE;
}

void DoPropertySheet(HWND hwndOwner)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~*/
	PROPSHEETPAGE	psp[2];
	PROPSHEETHEADER psh;
	/*~~~~~~~~~~~~~~~~~~~~~~~*/

	psp[0].dwSize = sizeof(PROPSHEETPAGE);
	psp[0].dwFlags = PSP_USETITLE;
	psp[0].hInstance = g_inst;
	psp[0].pszTemplate = MAKEINTRESOURCE(IDD_APPEARENCE);
	psp[0].pszIcon = NULL;
	psp[0].pfnDlgProc = AppearenceDialogProc;
	psp[0].pszTitle = "Appearence";
	psp[0].lParam = 0;

	psp[1].dwSize = sizeof(PROPSHEETPAGE);
	psp[1].dwFlags = PSP_USETITLE;
	psp[1].hInstance = g_inst;
	psp[1].pszTemplate = MAKEINTRESOURCE(IDD_HOTKEY);
	psp[1].pszIcon = NULL;
	psp[1].pfnDlgProc = HotKeyDialogProc;
	psp[1].pszTitle = "HotKey";
	psp[1].lParam = 0;

	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_PROPSHEETPAGE;
	psh.hwndParent = hwndOwner;
	psh.hInstance = g_inst;
	psh.pszIcon = NULL;
	psh.pszCaption = (LPSTR) "BarCommander Options";
	psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
	psh.ppsp = (LPCPROPSHEETPAGE) & psp;

	/* Store current bcfg incase of revert */
	bc_old = *bc;

	PropertySheet(&psh);
	return;
}
