/*$off*/
/*********************************************************************
 *
 * Copyright (C) 2002,  Tom Picot
 * Description:  A floating command toolbar for Windows.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 ********************************************************************/
/*$on*/
#include <windows.h>

#include "taskbar.h"

BOOL MyTaskBarAddIcon(HWND hwnd, UINT uID, HICON hicon, LPSTR lpszTip)
{
	/*~~~~~~~~~~~~~~~~~~~~~*/
	BOOL			res;
	NOTIFYICONDATA	tnid;
	/*~~~~~~~~~~~~~~~~~~~~~*/

	tnid.cbSize = sizeof(NOTIFYICONDATA);
	tnid.hWnd = hwnd;
	tnid.uID = uID;
	tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	tnid.uCallbackMessage = UWM_SYSTRAY;
	tnid.hIcon = hicon;
	if(lpszTip)
		lstrcpyn(tnid.szTip, lpszTip, sizeof(tnid.szTip));
	else
		tnid.szTip[0] = '\0';

	res = Shell_NotifyIcon(NIM_ADD, &tnid);

	if(hicon) DestroyIcon(hicon);

	return res;
}

BOOL MyTaskBarDeleteIcon(HWND hwnd, UINT uID)
{
	/*~~~~~~~~~~~~~~~~~~~~~*/
	BOOL			res;
	NOTIFYICONDATA	tnid;
	/*~~~~~~~~~~~~~~~~~~~~~*/

	tnid.cbSize = sizeof(NOTIFYICONDATA);
	tnid.hWnd = hwnd;
	tnid.uID = uID;

	res = Shell_NotifyIcon(NIM_DELETE, &tnid);
	return res;
}
