#include <windows.h>
#include <tchar.h>

typedef struct
{
	TCHAR	 szURL[_MAX_PATH];	// desination URL
	WNDPROC  oldproc;			// old window procedure
	COLORREF crLink;			// current link colour
	COLORREF crVisited;			// colour when VISITED

} URLCtrl;

static HFONT	hfUnderlined = 0;
static HCURSOR	hCursor      = 0;

/* XOR mask for hand cursor */
/* Generated by HexEdit */
BYTE XORMask[128] =
{
  0xff, 0xff, 0xff, 0xff,
  0xf9, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff,
  0xf0, 0xff, 0xff, 0xff, 
  0xf0, 0x24, 0xff, 0xff, 
  0xf0, 0x00, 0x7f, 0xff, 
  0xc0, 0x00, 0x7f, 0xff,
  0x80, 0x00, 0x7f, 0xff, 
  0x80, 0x00, 0x7f, 0xff, 
  0x80, 0x00, 0x7f, 0xff, 
  0x80, 0x00, 0x7f, 0xff,
  0x80, 0x00, 0x7f, 0xff, 
  0xc0, 0x00, 0x7f, 0xff, 
  0xe0, 0x00, 0x7f, 0xff, 
  0xf0, 0x00, 0xff, 0xff,
  0xf0, 0x00, 0xff, 0xff, 
  0xf0, 0x00, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 
};

/* AND mask for hand cursor */
/* Generated by HexEdit */
BYTE ANDMask[128] =
{
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x00, 0x00, 
  0x06, 0xdb, 0x00, 0x00,
  0x06, 0xdb, 0x00, 0x00, 
  0x36, 0xdb, 0x00, 0x00, 
  0x36, 0xdb, 0x00, 0x00, 
  0x37, 0xff, 0x00, 0x00, 
  0x3f, 0xff, 0x00, 0x00,
  0x3f, 0xff, 0x00, 0x00, 
  0x1f, 0xff, 0x00, 0x00, 
  0x0f, 0xff, 0x00, 0x00, 
  0x07, 0xfe, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
};

//
//	Subclass window procedure for a static control
//
LRESULT CALLBACK URLCtrlProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	URLCtrl		*url = (URLCtrl *)GetWindowLong(hwnd, GWL_USERDATA);
	WNDPROC		oldproc = url->oldproc;
	
	HDC			hdc;
	HANDLE		hOld;
	PAINTSTRUCT ps;
	RECT		rect;
	DWORD		dwStyle;
	DWORD		dwDTStyle = 0;
	UINT		ret;
	
	static BOOL  fClicking;
	static TCHAR szWinText[_MAX_PATH];

	switch(iMsg)
	{
	// Free up the structure we allocated
	case WM_NCDESTROY:
		HeapFree(GetProcessHeap(), 0, url);
		break;
	
	// Paint the static control using our custom
	// colours, and with an underline text style
	case WM_PAINT:
		
		dwStyle = GetWindowLong(hwnd, GWL_STYLE);
		
		dwDTStyle = DT_SINGLELINE;
		
		//Test if centered horizontally or vertically
		if(dwStyle & SS_CENTER)	     dwDTStyle |= DT_CENTER;
		if(dwStyle & SS_RIGHT)		 dwDTStyle |= DT_RIGHT;
		if(dwStyle & SS_CENTERIMAGE) dwDTStyle |= DT_VCENTER;

		GetClientRect(hwnd, &rect);

		hdc = BeginPaint(hwnd, &ps);
		
		SetTextColor(hdc, url->crLink);
		SetBkColor  (hdc, GetSysColor(COLOR_3DFACE));
		
		// Create an underline font 
		if(hfUnderlined == 0)
		{
			// Get the default GUI font
			LOGFONT lf;
			HFONT hf = (HFONT)GetStockObject(DEFAULT_GUI_FONT);

			// Add UNDERLINE attribute
			GetObject(hf, sizeof lf, &lf);
            lf.lfUnderline = TRUE;
			
			// Create a new font
			hfUnderlined = CreateFontIndirect(&lf);
		}
		
		hOld = SelectObject(hdc, hfUnderlined);

		// Draw the text!
		GetWindowText(hwnd, szWinText, sizeof szWinText);
		DrawText(hdc, szWinText, -1, &rect, dwDTStyle);
		
		SelectObject(hdc, hOld);

		EndPaint(hwnd, &ps);

		return 0;

	case WM_SETTEXT:
		ret = CallWindowProc(oldproc, hwnd, iMsg, wParam, lParam);
		InvalidateRect(hwnd, 0, 0);
		return ret;

	// Provide a hand cursor when the mouse moves over us
	case WM_SETCURSOR:

		if(hCursor == 0)
			hCursor = CreateCursor(GetModuleHandle(0), 5, 2, 32, 32, XORMask, ANDMask);
		
		SetCursor(hCursor);
		return TRUE;

	case WM_LBUTTONDOWN:
		fClicking = TRUE;
		break;

	case WM_LBUTTONUP:
		
		if(fClicking)
		{
			fClicking = FALSE;
			url->crLink = url->crVisited;
			
			InvalidateRect(hwnd, 0, 0);
			UpdateWindow(hwnd);

			// Open a browser
			if(url->szURL[0])
			{
				ShellExecute(NULL, _T("open"), url->szURL, NULL, NULL, SW_SHOWNORMAL);
			}
			else
			{
				GetWindowText(hwnd, szWinText, sizeof szWinText);
				ShellExecute(NULL, _T("open"), szWinText, NULL, NULL, SW_SHOWNORMAL);
			}
		}

		break;
		
	// A standard static control returns HTTRANSPARENT here, which
	// prevents us from receiving any mouse messages. So, return
	// HTCLIENT instead.
	case WM_NCHITTEST:
		return HTCLIENT;
	}

	return CallWindowProc(oldproc, hwnd, iMsg, wParam, lParam);
}

//
//	Create a URL control from the specified static control
//
//	crLink --  -1 for default
//
BOOL StaticToURLControl(HWND hDlg, UINT staticid, TCHAR *szURL, COLORREF crLink)
{
	HWND hwndCtrl = GetDlgItem(hDlg, staticid);
	
	// Allocate memory for the URL structure
	URLCtrl *url = (URLCtrl *)HeapAlloc(GetProcessHeap(), 0, sizeof(URLCtrl));
	
	// turn on notify style
    SetWindowLong(hwndCtrl, GWL_STYLE, GetWindowLong(hwndCtrl, GWL_STYLE) | SS_NOTIFY);

	// set the URL text (not the display text)
	if(szURL)
		lstrcpy(url->szURL, szURL);
	else
		url->szURL[0] = _T('\0');

	// set the hyperlink colour
	if(crLink != -1) url->crLink = crLink;
	else             url->crLink = RGB(0,0,255);

	// set the visited colour
	url->crVisited = RGB(128,0,128);

	// subclass the static control
	url->oldproc = (WNDPROC)SetWindowLong(hwndCtrl, GWL_WNDPROC, (LONG)URLCtrlProc);

	// associate the URL structure with the static control
	SetWindowLong(hwndCtrl, GWL_USERDATA, (LONG)url);
	
	return TRUE;
}

// Call this function to free up the cursor and font
// resources used by a URL control
void CleanupURLControl()
{
	if(hfUnderlined) DeleteObject(hfUnderlined);
	if(hCursor)	     DestroyCursor(hCursor);
}