/*
 Written by D'Arcy J.M. Cain
 darcy@druid.net
 Copyright 1994-1997
 
 Do not change this file directly
 
 */
#include	<string.h>

#ifndef	__CAIN_STRING_H
#define	__CAIN_STRING_H
typedef	struct
{
char		*scanpoint;
char		*str2parse;
const char	*delim;
int			quote;
} XSTRTOK;
#if		!defined(bzero)
#define		bcmp(s1, s2, l)		memcmp(s1, s2, l)
#define		bcopy(s1, s2, l)	memcpy(s2, s1, l)
#define		bzero(dst, l)		memset(dst, 0, l)
#endif
#if		!defined(rindex)
#define		index(s, c)			strchr(s, c)
#define		rindex(s, c)		strrchr(s, c)
#endif
#if !defined(strcmpi)
#define		strcmpi(s1, s2)		stricmp(s1, s2)
#endif
#if !defined(strncmpi)
#define		strncmpi(s1, s2, n)	strnicmp(s1, s2, n)
#endif
#define		streq(s1, s2)		(strcmp(s1, s2) == 0)
#define		strieq(s1, s2)		(stricmp(s1, s2) == 0)
#define		strneq(s1, s2, n)	(strncmp(s1, s2, n) == 0)
#define		strnieq(s1, s2, n)	(strncmpi(s1, s2, n) == 0)
#define		strneq(s1, s2, n)	(strncmp(s1, s2, n) == 0)
#define		strcoll(s1, s2)		strcmp(s1, s2)
extern char *	xstrtok(XSTRTOK *);
extern int	 	stricmp(const char *, const char *);
extern char *	strip_spaces(char *p);
extern int	 	strnicmp(const char *, const char *, size_t);
extern char *	strdup(const char *);
#endif
