/* on_top.c 
 * 
 * Coded by Tom Picot. tom@tompicot.com. www.tompicot.com
 *
 * Pretty hacky code, but works alright :)
 *
 * Feel free to do what you want with this code.
 */


#include <windows.h>
#include <windowsx.h>

#include "resource.h"

#include "taskbar.h"
#include "about.h"

HINSTANCE	ghInst;

void move_window_bottomright(HWND hwnd){
	RECT rc,wa;
	int width, height;
	GetWindowRect(hwnd,&rc);
	SystemParametersInfo(SPI_GETWORKAREA, 0, &wa, 0);

	width = (rc.right - rc.left);
	height = (rc.bottom-rc.top);

	SetWindowPos(hwnd,NULL,wa.right - width,wa.bottom - height,0,0,SWP_NOSIZE);
}

BOOL CALLBACK add_wnd_to_list(HWND hwnd,LPARAM lParam){
	if(IsWindowVisible(hwnd)){
		int len = GetWindowTextLength(hwnd);
		if(len != 0){
			char *text = malloc(len+1);
			if(text){
				GetWindowText(hwnd,text,len+1);
				ListBox_SetItemData((HWND)lParam,ListBox_AddString((HWND)lParam, text),hwnd);
				free(text);
			}
		}
	}
	return TRUE;
}

BOOL CALLBACK ListProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{	
	static HWND list;
	static int *position;

    switch (message)
    {
		case WM_SHOWWINDOW:
		case WM_INITDIALOG:
			if(!list)
				 list = GetDlgItem(hwnd, IDC_LIST);

			ListBox_ResetContent(list);
			EnumWindows(add_wnd_to_list,(LPARAM)list);

			position = malloc(ListBox_GetCount(list)*sizeof(int));
			memset(position,0,ListBox_GetCount(list)*sizeof(int));

			move_window_bottomright(hwnd);
			return TRUE;

		case WM_CLOSE:
			free(position);
			ShowWindow(hwnd,SW_HIDE);
			return TRUE;

		case WM_COMMAND:
			switch(HIWORD(wParam))
			{
				case LBN_DBLCLK:
				{
					int cursel = ListBox_GetCurSel(list);
					HWND wnd = (HWND)ListBox_GetItemData(list,cursel);

					if(position[cursel] == FALSE){
						SetWindowPos(wnd,HWND_TOPMOST,0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
						position[cursel] = TRUE;
					} else {
						SetWindowPos(wnd,HWND_NOTOPMOST,0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
						position[cursel] = FALSE;
					}
				}
					break;
			}
			break;
    }
    return FALSE;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	POINT			pt;
	HMENU			menu, popup;
	static HWND list;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	switch(msg)
	{	
		case WM_CREATE:
			taskbar_add(hwnd, UWM_SYSTRAY, LoadIcon(ghInst,MAKEINTRESOURCE(IDI_MYICON)), "on_top");
			list = CreateDialog(ghInst,MAKEINTRESOURCE(IDD_WINDOWS),hwnd,(DLGPROC)ListProc);
			return TRUE;

		case WM_DESTROY:
			taskbar_delete(hwnd, UWM_SYSTRAY);
			PostQuitMessage(0);
			return TRUE;
		
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case ID_EXIT:
					DestroyWindow(hwnd);
					break;
				case ID_ABOUT:
					DialogBox(ghInst,MAKEINTRESOURCE(IDD_ABOUT),hwnd,(DLGPROC)AboutDlgProc);
					break;
			}

		case UWM_SYSTRAY:
			switch(lParam)
			{
				case WM_RBUTTONUP:
					GetCursorPos(&pt);

					menu = LoadMenu(ghInst, MAKEINTRESOURCE(IDM_TRAY));
					popup = GetSubMenu(menu, 0);

					SetForegroundWindow(hwnd);

					TrackPopupMenu(popup, TPM_RIGHTBUTTON, pt.x, pt.y, 0, hwnd, NULL);

					PostMessage(hwnd, 0, 0, 0);

					DestroyMenu(menu);
					break;

				case WM_LBUTTONUP:
					ShowWindow(list,SW_SHOW);
					SetForegroundWindow(list);
					SetWindowPos(list,HWND_TOPMOST,0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
					SendMessage(list,WM_SHOWWINDOW,0,0); /* force refresh */
					break;				
			}
			return TRUE;
	}

	return DefWindowProc(hwnd, msg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	HWND			hwnd;
	WNDCLASSEX		wc;
	MSG				msg;
	char			*classname = "on_top";
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	ghInst = hInstance;

	SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS);

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = 0;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MYICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = classname;
	wc.hIconSm = LoadImage
		(
			hInstance,
			MAKEINTRESOURCE(IDI_MYICON),
			IMAGE_ICON,
			GetSystemMetrics(SM_CXSMICON),
			GetSystemMetrics(SM_CYSMICON),
			0
		);
	RegisterClassEx(&wc);

	hwnd = CreateWindowEx
		(
			0,
			classname,
			classname,
			WS_POPUP,
			CW_USEDEFAULT,
			0,
			CW_USEDEFAULT,
			0,
			NULL,
			NULL,
			hInstance,
			NULL
		);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int)msg.wParam;
}
